Attribute VB_Name = "mWndProc"
Option Explicit
'
' Brad Martinez  http://www.mvps.org/ccrp
'
' Code was written in and formatted for 8pt MS San Serif

Public g_fMsgs As Boolean

' The NMHDR structure contains information about a notification message. The pointer
' to this structure is specified as the lParam member of the WM_NOTIFY message.
Public Type NMHDR
  hwndFrom As Long   ' Window handle of control sending message
  idFrom As Long        ' Identifier of control sending message
  code  As Long          ' Specifies the notification code
End Type

Private Const WM_NOTIFY = &H4E
Private Const WM_DESTROY = &H2

Private Declare Function GetProp Lib "user32" Alias "GetPropA" (ByVal hWnd As Long, ByVal lpString As String) As Long
Private Declare Function SetProp Lib "user32" Alias "SetPropA" (ByVal hWnd As Long, ByVal lpString As String, ByVal hData As Long) As Long
Private Declare Function RemoveProp Lib "user32" Alias "RemovePropA" (ByVal hWnd As Long, ByVal lpString As String) As Long

Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" (pDest As Any, pSource As Any, ByVal dwLength As Long)

Public Enum GWL_nIndex
  GWL_WNDPROC = (-4)
'  GWL_HWNDPARENT = (-8)
  GWL_ID = (-12)
  GWL_STYLE = (-16)
  GWL_EXSTYLE = (-20)
'  GWL_USERDATA = (-21)
End Enum

Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As GWL_nIndex) As Long
Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As GWL_nIndex, ByVal dwNewLong As Long) As Long

Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function DefWindowProc Lib "user32" Alias "DefWindowProcA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

' Window property string IDs used to store the WebBrowserEx's
' object reference pointer and window procedure pointer.
Public Const OBJECTPTR = "ObjectPtr"
Public Const OLDWNDPROC = "OldWndProc"

' The value of this conditional compilation constant is set on this project's Properties
' dialog box. The constant is used with the "Debug Object for AddressOf Subclassing"
' (Dbgwproc.dll) found at the VB owner's area on the MS web site, which is distributable
' and included with this project. In order to use it's services, allowing you to break and step
' through code execution during a window procedure call (which would normally produce
' unexpected results), it must be present and correctly registered on your system, and
' referenced by this project. See the included DbgReadme.txt file for more information.
#If DEBUGWINDOWPROC Then
  ' Maintains a WindowProcHook reference for each subclassed
  ' window. The window's handle is each collection item's Key string.
  Private m_colWPHooks As New Collection
#End If
'

Public Function SubClass(hWnd As Long, _
                                         lpfnNew As Long, _
                                         objWBE As ExplorerView) As Boolean
  Dim lpfnOld As Long
  Dim fSuccess As Boolean
  On Error GoTo Out
  
  If GetProp(hWnd, OLDWNDPROC) Then
    SubClass = True
    Exit Function
  End If
  
#If (DEBUGWINDOWPROC = 0) Then
    lpfnOld = SetWindowLong(hWnd, GWL_WNDPROC, lpfnNew)

#Else
    Dim objWPHook As WindowProcHook
    
    Set objWPHook = CreateWindowProcHook
    m_colWPHooks.Add objWPHook, CStr(hWnd)
    
    With objWPHook
      Call .SetMainProc(lpfnNew)
      lpfnOld = SetWindowLong(hWnd, GWL_WNDPROC, .ProcAddress)
      Call .SetDebugProc(lpfnOld)
    End With

#End If
  
  If lpfnOld Then
    If SetProp(hWnd, OLDWNDPROC, lpfnOld) Then
      fSuccess = SetProp(hWnd, OBJECTPTR, ObjPtr(objWBE))
    End If
  End If
  
Out:
  If fSuccess Then
    SubClass = True
  
  Else
    If lpfnOld Then Call SetWindowLong(hWnd, GWL_WNDPROC, lpfnOld)
    MsgBox "Error subclassing window &H" & Hex(hWnd) & vbCrLf & vbCrLf & _
                  "Err# " & Err.Number & ": " & Err.Description, vbExclamation
  End If
  
End Function

Public Function UnSubClass(hWnd As Long) As Boolean
  Dim lpfnOld As Long
  
  lpfnOld = GetProp(hWnd, OLDWNDPROC)
  If lpfnOld Then
    
    If SetWindowLong(hWnd, GWL_WNDPROC, lpfnOld) Then
      Call RemoveProp(hWnd, OLDWNDPROC)
      Call RemoveProp(hWnd, OBJECTPTR)

#If DEBUGWINDOWPROC Then
      ' remove the WindowProcHook reference from the collection
      m_colWPHooks.Remove CStr(hWnd)
#End If
      
      UnSubClass = True
    
    End If   ' SetWindowLong
  End If   ' lpfnOld

End Function

' Returns the ExplorerView object reference from the specified window handle.
' The returned object lives for as long as the calling proc holds onto it.

Public Function GetEV(hWnd As Long) As ExplorerView
  Dim objEV As ExplorerView
  Dim pEV As Long
  
  pEV = GetProp(hWnd, OBJECTPTR)
  If pEV Then
    MoveMemory objEV, pEV, 4
    Set GetEV = objEV
    FillMemory objEV, 4, 0
  End If

End Function

' Receives the WebBrowser control's window messages

Public Function WBWndProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

If g_fMsgs Then
  Debug.Print "wb: &H" & Hex(hWnd) & ", " & GetWinMsgStr(uMsg) & _
                        ", &H" & Hex(wParam) & ", &H" & Hex(lParam)
End If

  Select Case uMsg
      
    ' ============================================================
    ' The WB gets WM_PARENTNOTIFY/WM_CREATE when the SysListView32
    ' has been created and has finished being initialized in the new SHELLDLL_DefView
    ' (or other) window. lParam points to the new SHELLDLL_DefView (or other) window.

    Case WM_PARENTNOTIFY
      Dim objEV As ExplorerView
      Dim hwndLV As Long

      If (LOWORD(wParam) = WM_CREATE) Then
        Set objEV = GetEV(hWnd)

        If (lParam = FindWindowEx(hWnd, 0, WC_WEBVIEW, vbNullString)) Then
          ' Viewing a web page (and not the shell), clear the EV's prop
          objEV.hwndSHView = 0
        Else
          ' Set the EV's prop and subclass the SHELLDLL_DefView
          ' (or whatever window is being used by the currently browsed
          ' namespace extension)
          objEV.hwndSHView = lParam
          Call SubClass(lParam, AddressOf SHViewWndProc, objEV)
        End If
        
        ' Find the listview and set the EV's prop
        hwndLV = FindWindowEx(lParam, 0, WC_LISTVIEW, vbNullString)
        objEV.hwndLV = hwndLV
        If hwndLV Then
          ' Switch its view now while it's hidden.
'          Call SwitchView(hwndLV, objEV.View)
          ' (we have to pull this monkey business for NT5, for some reason
          '  when the WebBrowser is subclassed, its listview sometimes
          ' forgets to create the header items, so we'll remind it...)
          Call SwitchSHView(lParam, LVS_ICON)
          Call SwitchSHView(lParam, LVS_REPORT)
          Call SwitchSHView(lParam, objEV.UserView)

          ' subclass the listview
          Call SubClass(hwndLV, AddressOf LVWndProc, objEV)
        End If

      End If
      
    ' ============================================================
    ' Unsubclass the window.
    
    Case WM_DESTROY
      ' OLDWNDPROC will be gone after UnSubClass is called!
      Call CallWindowProc(GetProp(hWnd, OLDWNDPROC), hWnd, uMsg, wParam, lParam)
      Call UnSubClass(hWnd)
      Exit Function
    
  End Select
    
  ' Default processing...
  WBWndProc = CallWindowProc(GetProp(hWnd, OLDWNDPROC), hWnd, uMsg, wParam, lParam)

End Function

' Receives the WebBrowser control's SHELLDLL_DefView window messages.
' This may not be a SHELLDLL_DefView for certain namespace extensions...

Public Function SHViewWndProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
  Dim objEV As ExplorerView

If g_fMsgs Then
  Debug.Print "sh: &H" & Hex(hWnd) & ", " & GetWinMsgStr(uMsg) & _
                        ", &H" & Hex(wParam) & ", &H" & Hex(lParam)
End If
  
  Select Case uMsg
      
    ' ============================================================
    ' Find the "&Explore" menu command in the context menu, make it the default
    ' command, and replace its menu ID so that the namespace extension's
    ' IContextMenu:InvokeCommand won't recognize it and execute it.
    ' --> The listview's context menu messages are sent to the listview's parent window <--
    
    Case WM_INITMENUPOPUP
      Dim idmExplore As Long
      Dim mii As MENUITEMINFO

      Set objEV = GetEV(hWnd)
      objEV.InMenuMode = True
      
      If Len(objEV.RClickedLVFolder) Then   ' set on WM_CONTEXTMENU
        ' First remove the default item
        Call SetMenuDefaultItem(wParam, -1, 0)
        
        ' Get and set the "Explore" command's ID and make it the default command.
        ' Hopefully with the new ID, IContextMenu:InvokeCommand won't be called...
        idmExplore = GetMenuItemIDFromStr(wParam, GetResourceString("shell32.dll", 8502))   ' "&Explore"
        If idmExplore Then
          mii.cbSize = Len(mii)
          mii.fMask = MIIM_ID Or MIIM_STATE
          mii.wID = 1
          mii.fState = MFS_DEFAULT
          Call SetMenuItemInfo(wParam, idmExplore, False, mii)
        Else
          objEV.RClickedLVFolder = ""
        End If
      
      End If   ' Len(m_sRClickedLVFolder)
      
    ' ============================================================
    
    Case WM_MENUSELECT
      Dim fMenuClosed As Boolean
      Dim idmTmp As Integer
      Static idmCur As Integer
      
      fMenuClosed = ((HIWORD(wParam) = &HFFFF) And (lParam = 0))
      
      Set objEV = GetEV(hWnd)
      ' Reset the ExplorerView's statusbar
      If fMenuClosed Then objEV.InMenuMode = False

      If Len(objEV.RClickedLVFolder) Then   ' set on NM_RCLICK,
        
        ' Get the current menu command ID
        idmTmp = LOWORD(wParam)
        
        ' If the menu is not being closed...
        If (fMenuClosed = False) Then
          ' Save the select command's ID
          idmCur = idmTmp
        Else
          
          ' The menu is being closed. Is the saved ID our new Explore ID?
          If (idmCur = 1) Then
            ' Yep, Find and select the folder in the FTV,
            ' navigating the WebBrowser to that folder.
            Call SelectFTVChildFolder(objEV.FolderTreeview.SelectedFolder, objEV.RClickedLVFolder)
          
            ' If default processing happens, we GPF... (?)
            Exit Function
          End If   '  (idmCur = 1)
          
          ' Clear the global string and the saved ID
          objEV.RClickedLVFolder = ""
          idmCur = 0
        
        End If   ' (idmTmp <> &HFFFF) And lParam
      End If   ' Len(m_sRClickedLVFolder)
      
    ' ============================================================
    ' Unsubclass the window.
    
    Case WM_DESTROY
      ' OLDWNDPROC will be gone after UnSubClass is called!
      Call CallWindowProc(GetProp(hWnd, OLDWNDPROC), hWnd, uMsg, wParam, lParam)
      Call UnSubClass(hWnd)
      Exit Function
    
  End Select
    
  ' Default processing...
  SHViewWndProc = CallWindowProc(GetProp(hWnd, OLDWNDPROC), hWnd, uMsg, wParam, lParam)

End Function

' Receives the WebBrowser control's grandchild listview control's window messages

Public Function LVWndProc(ByVal hwndLV As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

If g_fMsgs Then
  Debug.Print "lv: &H" & Hex(hwndLV) & ", " & GetWinMsgStr(uMsg) & _
                        ", &H" & Hex(wParam) & ", &H" & Hex(lParam)
End If

  Select Case uMsg
      
    ' ============================================================
    ' Process keyboard input
    
    Case WM_KEYDOWN
'      If (wParam = vbKeyTab) And (GetFocus = hwndLV) Then
'        ' Give the FTV input focus on a tab keydown
'        Call SetFocusAPI(GetEV(hwndLV).hwndFTV)
      
      If (wParam = vbKeyReturn) Then
        ' Navigate the FTV to the selected listview item (if a folder)
        If DoLVMessage(GetEV(hwndLV), hwndLV, _
                                   ListView_GetSelectedItem(hwndLV), WM_KEYDOWN) Then
          Exit Function
        End If
      
      ElseIf (wParam = vbKeyBack) Then
        ' Navigate the FTV to its SelectedFolder's Parent folder. Error trap
        ' in case the SelectedFolder is the RootFolder (its parent is Nothing)
        On Error Resume Next
        GetEV(hwndLV).FolderTreeview.SelectedFolder.Parent.Selected = True
        On Error GoTo 0
      
      End If
    
    ' ============================================================
    ' Process mouse input
    
    Case WM_LBUTTONDOWN, WM_LBUTTONDBLCLK, WM_CONTEXTMENU
      Dim fDoMouseInput As Boolean
      Dim pt As POINTAPI
      Dim lvhti As LVHITTESTINFO
      
      ' Exit if not showing the listview's context menu
      If ((uMsg = WM_CONTEXTMENU) And (GetEV(hwndLV).ContextMenu = False)) Then
        Exit Function
      End If
      
      fDoMouseInput = True
      ' Process the left button down if the system is set to single click execution.
      If (uMsg = WM_LBUTTONDOWN) Then fDoMouseInput = IsSingleClickToOpenItem
      
      If fDoMouseInput Then
        
        ' See if the mouse pointer is over an item.
        Call GetCursorPos(pt)
        Call ScreenToClient(hwndLV, pt)
        lvhti.pt = pt
        Call ListView_HitTest(hwndLV, lvhti)
        If (lvhti.Flags And LVHT_ONITEM) Then
          If DoLVMessage(GetEV(hwndLV), hwndLV, lvhti.iItem, uMsg) Then
            Exit Function
          End If
        End If
      
      End If   ' fDoMouseInput
      
    ' ============================================================
    ' Unsubclass the window.
    
    Case WM_DESTROY
      ' OLDWNDPROC will be gone after UnSubClass is called!
      Call CallWindowProc(GetProp(hwndLV, OLDWNDPROC), hwndLV, uMsg, wParam, lParam)
      Call UnSubClass(hwndLV)
      Exit Function
    
  End Select
    
  ' Default processing...
  LVWndProc = CallWindowProc(GetProp(hwndLV, OLDWNDPROC), hwndLV, uMsg, wParam, lParam)

End Function

' Returns a window's generic message string from its value.  196 msgs...

Public Function GetWinMsgStr(uMsg As Long) As String
  Dim sMsg As String
  Select Case uMsg
    Case &H0: sMsg = "WM_NULL"
    Case &H1: sMsg = "WM_CREATE"
    Case &H2: sMsg = "WM_DESTROY"
    Case &H3: sMsg = "WM_MOVE"
    Case &H5: sMsg = "WM_SIZE"
    Case &H6: sMsg = "WM_ACTIVATE"
    Case &H7: sMsg = "WM_SETFOCUS"
    Case &H8: sMsg = "WM_KILLFOCUS"
    Case &HA: sMsg = "WM_ENABLE"
    Case &HB: sMsg = "WM_SETREDRAW"
    Case &HC: sMsg = "WM_SETTEXT"
    Case &HD: sMsg = "WM_GETTEXT"
    Case &HE: sMsg = "WM_GETTEXTLENGTH"
    Case &HF: sMsg = "WM_PAINT"
    Case &H10: sMsg = "WM_CLOSE"
    Case &H11: sMsg = "WM_QUERYENDSESSION"
    Case &H12: sMsg = "WM_QUIT"
    Case &H13: sMsg = "WM_QUERYOPEN"
    Case &H14: sMsg = "WM_ERASEBKGND"
    Case &H15: sMsg = "WM_SYSCOLORCHANGE"
    Case &H16: sMsg = "WM_ENDSESSION"
    Case &H18: sMsg = "WM_SHOWWINDOW"
    Case &H19: sMsg = "WM_CTLCOLOR"
    Case &H1A: sMsg = "WM_SETTINGCHANGE"
'    Case &H1A: sMsg = "WM_WININICHANGE"
    Case &H1B: sMsg = "WM_DEVMODECHANGE"
    Case &H1C: sMsg = "WM_ACTIVATEAPP"
    Case &H1D: sMsg = "WM_FONTCHANGE"
    Case &H1E: sMsg = "WM_TIMECHANGE"
    Case &H1F: sMsg = "WM_CANCELMODE"
    Case &H20: sMsg = "WM_SETCURSOR"
    Case &H21: sMsg = "WM_MOUSEACTIVATE"
    Case &H22: sMsg = "WM_CHILDACTIVATE"
    Case &H23: sMsg = "WM_QUEUESYNC"
    Case &H24: sMsg = "WM_GETMINMAXINFO"
    Case &H26: sMsg = "WM_PAINTICON"
    Case &H27: sMsg = "WM_ICONERASEBKGND"
    Case &H28: sMsg = "WM_NEXTDLGCTL"
    Case &H2A: sMsg = "WM_SPOOLERSTATUS"
    Case &H2B: sMsg = "WM_DRAWITEM"
    Case &H2C: sMsg = "WM_MEASUREITEM"
    Case &H2D: sMsg = "WM_DELETEITEM"
    Case &H2E: sMsg = "WM_VKEYTOITEM"
    Case &H2F: sMsg = "WM_CHARTOITEM"
    Case &H30: sMsg = "WM_SETFONT"
    Case &H31: sMsg = "WM_GETFONT"
    Case &H32: sMsg = "WM_SETHOTKEY"
    Case &H33: sMsg = "WM_GETHOTKEY"
    Case &H37: sMsg = "WM_QUERYDRAGICON"
    Case &H39: sMsg = "WM_COMPAREITEM"
    Case &H41: sMsg = "WM_COMPACTING"
    Case &H44: sMsg = "WM_COMMNOTIFY"
    Case &H46: sMsg = "WM_WINDOWPOSCHANGING"
    Case &H47: sMsg = "WM_WINDOWPOSCHANGED"
    Case &H48: sMsg = "WM_POWER"
    Case &H4A: sMsg = "WM_COPYDATA"
    Case &H4B: sMsg = "WM_CANCELJOURNAL"
    Case &H4E: sMsg = "WM_NOTIFY"
    Case &H50: sMsg = "WM_INPUTLANGCHANGEREQUEST"
    Case &H51: sMsg = "WM_INPUTLANGCHANGE"
    Case &H52: sMsg = "WM_TCARD"
    Case &H53: sMsg = "WM_HELP"
    Case &H54: sMsg = "WM_USERCHANGED"
    Case &H55: sMsg = "WM_NOTIFYFORMAT"
    Case &H7B: sMsg = "WM_CONTEXTMENU"
    Case &H7C: sMsg = "WM_STYLECHANGING"
    Case &H7D: sMsg = "WM_STYLECHANGED"
    Case &H7E: sMsg = "WM_DISPLAYCHANGE"
    Case &H7F: sMsg = "WM_GETICON"
    Case &H80: sMsg = "WM_SETICON"
    Case &H81: sMsg = "WM_NCCREATE"
    Case &H82: sMsg = "WM_NCDESTROY"
    Case &H83: sMsg = "WM_NCCALCSIZE"
    Case &H84: sMsg = "WM_NCHITTEST"
    Case &H85: sMsg = "WM_NCPAINT"
    Case &H86: sMsg = "WM_NCACTIVATE"
    Case &H87: sMsg = "WM_GETDLGCODE"
    Case &HA0: sMsg = "WM_NCMOUSEMOVE"
    Case &HA1: sMsg = "WM_NCLBUTTONDOWN"
    Case &HA2: sMsg = "WM_NCLBUTTONUP"
    Case &HA3: sMsg = "WM_NCLBUTTONDBLCLK"
    Case &HA4: sMsg = "WM_NCRBUTTONDOWN"
    Case &HA5: sMsg = "WM_NCRBUTTONUP"
    Case &HA6: sMsg = "WM_NCRBUTTONDBLCLK"
    Case &HA7: sMsg = "WM_NCMBUTTONDOWN"
    Case &HA8: sMsg = "WM_NCMBUTTONUP"
    Case &HA9: sMsg = "WM_NCMBUTTONDBLCLK"
    Case &H100: sMsg = "WM_KEYDOWN"
'    Case &H100: sMsg = "WM_KEYFIRST"
    Case &H101: sMsg = "WM_KEYUP"
    Case &H102: sMsg = "WM_CHAR"
    Case &H103: sMsg = "WM_DEADCHAR"
    Case &H104: sMsg = "WM_SYSKEYDOWN"
    Case &H105: sMsg = "WM_SYSKEYUP"
    Case &H106: sMsg = "WM_SYSCHAR"
    Case &H107: sMsg = "WM_SYSDEADCHAR"
    Case &H108: sMsg = "WM_KEYLAST"
'    Case &H109: sMsg = "WM_WNT_CONVERTREQUESTEX"
    Case &H109: sMsg = "WM_CONVERTREQUESTEX"
    Case &H10A: sMsg = "WM_CONVERTREQUEST"
    Case &H10B: sMsg = "WM_CONVERTRESULT"
    Case &H10C: sMsg = "WM_INTERIM"
    Case &H10D: sMsg = "WM_IME_STARTCOMPOSITION"
    Case &H10E: sMsg = "WM_IME_ENDCOMPOSITION"
    Case &H10F: sMsg = "WM_IME_COMPOSITION"
'    Case &H10F: sMsg = "WM_IME_KEYLAST"
    Case &H110: sMsg = "WM_INITDIALOG"
    Case &H111: sMsg = "WM_COMMAND"
    Case &H112: sMsg = "WM_SYSCOMMAND"
    Case &H113: sMsg = "WM_TIMER"
    Case &H114: sMsg = "WM_HSCROLL"
    Case &H115: sMsg = "WM_VSCROLL"
    Case &H116: sMsg = "WM_INITMENU"
    Case &H117: sMsg = "WM_INITMENUPOPUP"
    Case &H11F: sMsg = "WM_MENUSELECT"
    Case &H120: sMsg = "WM_MENUCHAR"
    Case &H121: sMsg = "WM_ENTERIDLE"
    Case &H132: sMsg = "WM_CTLCOLORMSGBOX"
    Case &H133: sMsg = "WM_CTLCOLOREDIT"
    Case &H134: sMsg = "WM_CTLCOLORLISTBOX"
    Case &H135: sMsg = "WM_CTLCOLORBTN"
    Case &H136: sMsg = "WM_CTLCOLORDLG"
    Case &H137: sMsg = "WM_CTLCOLORSCROLLBAR"
    Case &H138: sMsg = "WM_CTLCOLORSTATIC"
'    Case &H200: sMsg = "WM_MOUSEFIRST"
    Case &H200: sMsg = "WM_MOUSEMOVE"
    Case &H201: sMsg = "WM_LBUTTONDOWN"
    Case &H202: sMsg = "WM_LBUTTONUP"
    Case &H203: sMsg = "WM_LBUTTONDBLCLK"
    Case &H204: sMsg = "WM_RBUTTONDOWN"
    Case &H205: sMsg = "WM_RBUTTONUP"
    Case &H206: sMsg = "WM_RBUTTONDBLCLK"
    Case &H207: sMsg = "WM_MBUTTONDOWN"
    Case &H208: sMsg = "WM_MBUTTONUP"
    Case &H209: sMsg = "WM_MBUTTONDBLCLK"
'    Case &H20A: sMsg = "WM_MOUSELAST"        ' >= NT4
    Case &H20A: sMsg = "WM_MOUSEWHEEL"    ' >= NT4
    Case &H210: sMsg = "WM_PARENTNOTIFY"
    Case &H211: sMsg = "WM_ENTERMENULOOP"
    Case &H212: sMsg = "WM_EXITMENULOOP"
    Case &H213: sMsg = "WM_NEXTMENU"
    Case &H214: sMsg = "WM_SIZING"
    Case &H215: sMsg = "WM_CAPTURECHANGED"
    Case &H216: sMsg = "WM_MOVING"
    Case &H218: sMsg = "WM_POWERBROADCAST"
    Case &H219: sMsg = "WM_DEVICECHANGE"
    Case &H220: sMsg = "WM_MDICREATE"
    Case &H221: sMsg = "WM_MDIDESTROY"
    Case &H222: sMsg = "WM_MDIACTIVATE"
    Case &H223: sMsg = "WM_MDIRESTORE"
    Case &H224: sMsg = "WM_MDINEXT"
    Case &H225: sMsg = "WM_MDIMAXIMIZE"
    Case &H226: sMsg = "WM_MDITILE"
    Case &H227: sMsg = "WM_MDICASCADE"
    Case &H228: sMsg = "WM_MDIICONARRANGE"
    Case &H229: sMsg = "WM_MDIGETACTIVE"
    Case &H230: sMsg = "WM_MDISETMENU"
    Case &H231: sMsg = "WM_ENTERSIZEMOVE"
    Case &H232: sMsg = "WM_EXITSIZEMOVE"
    Case &H233: sMsg = "WM_DROPFILES"
    Case &H234: sMsg = "WM_MDIREFRESHMENU"
    Case &H280: sMsg = "WM_IME_REPORT"
    Case &H281: sMsg = "WM_IME_SETCONTEXT"
    Case &H282: sMsg = "WM_IME_NOTIFY"
    Case &H283: sMsg = "WM_IME_CONTROL"
    Case &H284: sMsg = "WM_IME_COMPOSITIONFULL"
    Case &H285: sMsg = "WM_IME_SELECT"
    Case &H286: sMsg = "WM_IME_CHAR"
    Case &H290: sMsg = "WM_IME_KEYDOWN"
    Case &H290: sMsg = "WM_IMEKEYDOWN"
    Case &H291: sMsg = "WM_IME_KEYUP"
    Case &H291: sMsg = "WM_IMEKEYUP"
    Case &H2A1: sMsg = "WM_MOUSEHOVER"    ' >= NT4
    Case &H2A3: sMsg = "WM_MOUSELEAVE"      ' >= NT4
    Case &H300: sMsg = "WM_CUT"
    Case &H301: sMsg = "WM_COPY"
    Case &H302: sMsg = "WM_PASTE"
    Case &H303: sMsg = "WM_CLEAR"
    Case &H304: sMsg = "WM_UNDO"
    Case &H305: sMsg = "WM_RENDERFORMAT"
    Case &H306: sMsg = "WM_RENDERALLFORMATS"
    Case &H307: sMsg = "WM_DESTROYCLIPBOARD"
    Case &H308: sMsg = "WM_DRAWCLIPBOARD"
    Case &H309: sMsg = "WM_PAINTCLIPBOARD"
    Case &H30A: sMsg = "WM_VSCROLLCLIPBOARD"
    Case &H30B: sMsg = "WM_SIZECLIPBOARD"
    Case &H30C: sMsg = "WM_ASKCBFORMATNAME"
    Case &H30D: sMsg = "WM_CHANGECBCHAIN"
    Case &H30E: sMsg = "WM_HSCROLLCLIPBOARD"
    Case &H30F: sMsg = "WM_QUERYNEWPALETTE"
    Case &H310: sMsg = "WM_PALETTEISCHANGING"
    Case &H311: sMsg = "WM_PALETTECHANGED"
    Case &H312: sMsg = "WM_HOTKEY"
    Case &H317: sMsg = "WM_PRINT"
    Case &H318: sMsg = "WM_PRINTCLIENT"
    
    Case Is < WM_USER:              sMsg = "&H" & Hex(uMsg) & " (unknown WM_ msg)"
    Case WM_USER To &H7FFF: sMsg = "WM_USER + " & uMsg - WM_USER & " (control specific msg)"
'    Case WM_USER To &H7FFF: sMsg = GetTVMsgStr(uMsg)
    Case &H8000& To &HBFFF&:   sMsg = "&H" & Hex(uMsg) & " (reserved msg)"
    Case &HC000& To &HFFFF&:   sMsg = "&H" & Hex(uMsg) & " (registered msg)"
    Case Else:                                sMsg = "&H" & Hex(uMsg) & " (reserved msg)"
  
  End Select
  
  GetWinMsgStr = sMsg

End Function
